#|___________________________________________________________________ 
 | 
 | ViSta - The Visual Statistics System
 | Copyright (c) 1991-2001 by Forrest W. Young
 | For further information contact the author 
 | forrest@www.visualstats.org
 | http://www.visualstats.org
 |
 | VINSTALL.LSP - THE VISTA RUNTIME INSTALLATION MANAGER
 |
 | ViSta comes here from the do-idle method in runtime\vista.lsp, or 
 | by explicit use of the (create-vista) function in a file read in 
 | by the -f option on the command line.
 |___________________________________________________________________
 |#


(defun create-vista (&key (hide-vista nil) (hide-logo nil) (starter nil))
(setf *hide-logo* hide-logo)
(setf *hide-vista* hide-vista)
(setf *starter* starter)
(setf *workmap-copyright* nil)
(backup-prefs-files) ;starter


#|
 | The do-idle method of *logo* is changed to catch errors during
 | startup. Depending on whether this is development or production
 | run, different behaviors will occur if processing stops unexpectedly.
 |#

(defmeth *logo* :do-idle () 
          (send self :idle-on nil)
          (cond
            (*devel-mode* (verbose t t) (stop-all-plots) (debug-options)
                          (send self :remove) )
            (t (please-wait "STARTUP ERROR: If problem persists, send email describing name of error and circumstances to forrest@visualstats.org" :title "Error")
               (send self :remove) (stop-all-plots)
               (defmeth *please-wait* :close () 
                 (exit)))))
        
(send *logo* :idle-on t)

(setf *screen-size* *real-screen-size*)
(setf screen-size *screen-size*)
(setf *now-screen-size* (effective-screen-size))

(defun desktop-style ()
  (setf *desktop-style* 
        (if *seamless-desktop* 
            (if *thin-borders* 1 3)
            (if *thin-borders* 7 8)))
  *desktop-style*)
 
(setf *desktop-container* 
      (container-window 
       :type (desktop-style)
       :size *now-screen-size* :mainwindow t 
       :show nil :local-menus t :top-most t :toolwindow nil :free t :putincontainer nil
       :title "ViSta - The Visual Statistics System"))
  
(send *desktop-container* :top-most nil)
(send *desktop-container* :title "ViSta DeskTop")

(setf *desktop-datasheet* nil)
(setf *vv* nil)
(setf *version6* t)
(setf *initial-datasheet* t)
(setf *free-datasheets* nil)
(setf *free-text-windows* t)
(setf *ni* t)

(defmeth *desktop-container* :close () (vista-exit))
  #+containers(send *desktop-container* :getobjects nil)

#|_______________________________ 
 | 
 | READ RUNTIME AND PHASE2 FILES
 |    the runtime files are menu files and files that depend on menus
 |    they must be read in while *desktop-container* is active
 |_______________________________ 
 |#


(when *verbose* (PRINT "READ RUNTIME FILES"))

(mapcar #'(lambda (file) 
            (load (strcat *runtime-dir-name* file)))
        *runtime-files*)

;phase2 updates can modify runtime file code

(when (load (strcat *default-path* "update\\phase2.lsp") :if-does-not-exist nil)
      (setf *updated* t)
      (when *verbose* (format t "; phase2 update~%")))

#|_______________________________ 
 | 
 | SET SCREEN SIZE & LOCATION
 | this is very old code and is real messy
 |_______________________________ 
 |#

#+containers
(progn 
 (setf *win-screen-size* (effective-screen-size)) 
 (labels ((desktop-loc-size 
           ()
           (if *full-screen*
               (combine 14 34 (- (effective-screen-size) (list 28 48)))
               (combine 14 34 (floor (* 3/4 (screen-size))))))

          (start-size 
           ()
           (when *verbose* (format t "Setting initial locations and sizes~%"))
           
           (setf *mainwindow-loc-size* (combine 4 24 (floor (* 3/4 (screen-size)))))
           (setf *listener-loc-size* (combine 4 24 (- (select *mainwindow-loc-size* (list 2 3)) (list 8 28))))
           (apply #'listener *listener-loc-size*)
           (apply #'mainwindow *mainwindow-loc-size*)
           (setf *desktop-loc-size* (desktop-loc-size)))
          )
   (cond 
   ((< *run-number* 2) (start-size)) 
   (t 
    (if (or (position nil *mainwindow-loc-size*)
            (position nil *listener-loc-size* ))
        (start-size))
    (apply #'mainwindow *mainwindow-loc-size*)
    (apply #'listener *listener-loc-size*)))
   (when (or (not (not (member nil *listener-loc-size*)))
             (< (third *listener-loc-size*) 250) 
             (< (fourth *listener-loc-size*) 100))
         (start-size))
 
   (when (or (not (not (member nil *desktop-loc-size*)))
             (< (third *desktop-loc-size*) 500) 
             (< (fourth *desktop-loc-size*) 350))
         (setf *desktop-loc-size* (desktop-loc-size)))
   (setf *desktop-start-loc-size* (+ '(4 4 -8 -8) *desktop-loc-size*))
   (setf *mainwindow-start-loc-size* *mainwindow-loc-size*)
   (apply #'mainwindow *mainwindow-loc-size*) 
   (listener 4 24 (- (third *mainwindow-loc-size*) 8)
             (- (fourth *mainwindow-loc-size*) 46))
   (setf *listener-start-loc-size* (listener))
 ))

(setf *no-restart* nil)
(setf *current-object* nil)

;this seems to work right fwy 10/2000

(defun reset-screen-size ()  
  (setf *screen-size* (screen-size))
  #+containers(defun screen-size () (effective-screen-size))
  (setf screen-size *screen-size*)
  (setf *max-screen-size* (screen-size)) 
  (setf *screen-size-adjustment* 
	#+msdos (list 0 0) ;4 24 ;4 54
	#-msdos (list 0 22))
  (setf *3/4-screen-size*                
        (- (floor (* 3/4 (screen-size))) *screen-size-adjustment*))
  (setf *text-window-size*
        #+macintosh (list 490 (max 112 (min 280 (- (second *screen-size*) 326))))
        #-macintosh (list 490 280)
        )
  (setf *text-window-location* 
        #+macintosh(list 10 (min 322 (- (first (screen-size)) 138))) 
        #-macintosh(list 10 30)
        )
  (when *verbose*
      (format t "*3/4-screen-size*          ~d~%" *3/4-screen-size*)
      (format t "*now-screen-size*          ~d~%" *now-screen-size*)
      (format t "*max-screen-size*          ~d~%" *max-screen-size*)
      (format t "*previous-max-screen-size* ~d~%" *previous-max-screen-size*)
      (format t "(screen-size) ~d~%" (screen-size))
      (format t "*screen-size* ~d~%" *screen-size*)
      (format t " screen-size  ~d~%"  screen-size )
      (format t "*screen-size-adjustment* ~d~%" *screen-size-adjustment*)
      (when (= (sum *now-screen-size*) 0) 
            (format t "; initializing screen size~%"))
        (when (/= 0 (sum (- *max-screen-size* *previous-max-screen-size*)))
              (format t "; screen size has changed~%")))
  
  (when (or (= (sum *now-screen-size*) 0)
            (/= 0 (sum (- *max-screen-size* *previous-max-screen-size*))))
        (setf *needs-desktop-resized* t)
       ; (setf *full-screen* t)
        (if *full-screen* 
            (if (= 1 *run-number*)
                (setf *screen-size* (- *max-screen-size* '(40 40)))
                (setf *screen-size* *max-screen-size*))
            (setf *screen-size* *3/4-screen-size*))
        (setf *now-screen-size* *screen-size*)
        (setf screen-size  *screen-size*))
  (setf *previous-max-screen-size* *max-screen-size*)
  (unless *desktop-loc-size*
          (setf *desktop-loc-size* (combine '(50 50) *3/4-screen-size*)))
  (when *verbose*
        (format t "*desktop-loc-size*         ~d~%" *desktop-loc-size*))
  (setf *mainwindow-loc-size* (mainwindow))
  (write-prefload-file)
  *needs-desktop-resized*)


(defun set-desktop-loc-size (&optional (open t))
  (when (and open 
             *desktop-container* 
             (send *desktop-container* :has-slot 'showing)
             (send *desktop-container* :showing))
        (combine (- (send *desktop-container* :location) '(0 0)) ;'(4 4)
                 (+ (send *desktop-container* :size) '(0 0)))))  ;'(8 8)


(reset-screen-size)

(when *verbose* (print "RESET-SCREEN-SIZE"))

#+macintosh (setf menu-bar-height 38)
#+macintosh (setf window-decoration-width 18) 
#+macintosh (setf window-decoration-height 18) 
#-msdos     (setf msdos-fiddle 0)
#-msdos     (setf border-thickness 0)
#+msdos(setf menu-bar-height 0)
#+msdos(setf window-decoration-width 8) ;8
#+msdos(setf window-decoration-height 28);8
#+msdos(setf border-thickness 3) ;4
#+msdos(setf msdos-fiddle 15)
#+X11 (setf menu-bar-height 0)
#+X11 (setf window-decoration-width 0)
#+X11 (setf window-decoration-height 0)



(when *verbose*
      (format t "(screen-size) ~d~%" (screen-size))
      (format t "*screen-size* ~d~%" *screen-size*)
      (format t " screen-size  ~d~%"  screen-size )
      (format t "*screen-size-adjustment* ~d~%" *screen-size-adjustment*)
      (when (= (sum *now-screen-size*) 0) 
            (format t "; initializing screen size~%"))
      (when (/= 0 (sum (- *max-screen-size* *previous-max-screen-size*)))
            (format t "; screen size has changed~%")))

(unless (= 1 *run-number*)
        (when (or (= (sum *now-screen-size*) 0)
                  (/= 0 (sum (- *max-screen-size* *previous-max-screen-size*))))
              (setf *needs-desktop-resized* t)
              (setf *full-screen* t)
              (setf *screen-size* *max-screen-size*)
              (setf *now-screen-size* *max-screen-size*)
              ))

(setf screen-size  *screen-size*)

#|_______________________________ 
 |  
 | make workmap
 |_______________________________ 
 |#

(make-vista-color-variables);was (default-colors)
(make-vista-color-constants)
(when *verbose* (format t "; MAKING WORKMAP~%"))

#+containers(when *ni* (enable-container *desktop-container*))

(setf *workmap* (workmap))
#+containers(when *ni* (disable-container))

(setf *desktop* *workmap*)
(send *workmap* :toolbar nil)
(setf *toolbox* (toolbox))
(setf *toolbar* *toolbox*)
                                             
(send *workmap* :num-data-menu-items
      (length (send (eval *data-menu*) :items))) 
(send *workmap* :num-model-menu-items
      (length (send (eval *model-menu*) :items))) 

(setf current-data nil)
(setf current-model nil)
(setf current-transf nil)
(setf current-object nil)
(setf *current-data* nil)
(setf *current-model* nil)
(setf *current-object* nil)
(setf *current-spreadplot* nil)
(setf *current-report-window* nil)
(setf *current-help-window* nil)
(setf *current-text-window* nil)
(setf *cd* nil)
(setf $ nil)  ;current-data
(setf $$ nil) ;current-model
(setf previous-data nil)
(setf *previous-data* nil)
(setf *guidemap* nil)
(setf *expertmap* nil)
(setf v-options '((0)))
 

#|_______________________________ 
 | 
 | make *vista* system object 
 |_______________________________ 
 |#


(WHEN *VERBOSE* (format t "; MAKE *VISTA* SYSTEM OBJECT~%"))

#+containers(when *ni* (enable-container *desktop-container* ))
(setf *vista* (vista-system))
#+containers(when *ni*  (disable-container))

(WHEN *VERBOSE* (format t "; MADE SYSTEM OBJECT~%"))

(setf *message-window* nil)
(send *vista* :show-load-vista *xlispstat-only*)
(send *toolbar* :initialize-master-lists)

#+msdos     (send *vista* :guide-window-size '(252 280)) 
#-msdos     (send *vista* :guide-window-size '(243 280)) 
(send *vista* :guide-window-location 
      (floor (/ (- *now-screen-size* (send *vista* :guide-window-size)) 2)))
(send *vista* :expert-window-size (send *vista* :guide-window-size))
(send *vista* :expert-window-location '(100 100))


#|_______________________________
 |
 | install menus 
 |_______________________________ 
 |#


(WHEN *VERBOSE* (format t "; INSTALLING MENUS~%"))

#+macintosh (send *apple-menu* :append-items 
                  (send menu-item-proto :new "About ViSta" :action 
                        #'(lambda () (about-vista))))

(defun make-long-menus ()
  (send *vista* :long-menus t)
  (send *data-menu* :append-items (send dash-item-proto :new)) 
  (send *model-menu* :append-items (send dash-item-proto :new)) 
  (send *workmap* :num-data-menu-items
        (1+ (send *workmap* :num-data-menu-items))) 
  (send *workmap* :num-model-menu-items
        (1+ (send *workmap* :num-model-menu-items))) )

(send *vista* :long-menus nil)
(send *workmap* :enabled-trans-menu nil)
(setf text-top nil)
(setf win-mac nil)
#+msdos(setf text-top t)
#+msdos(setf win-mac t)

#|_______________________________
 |
 | read PREFS.LSP, DESKTOP.LSP and WORKMAP.LSP files 
 |_______________________________ 
 |#


(WHEN *VERBOSE* (format t "; LOADING *VISTA* PREF FILES (PREFS DESKTOP WORKMAP)~%"))
(failsafe-load *prefs-dir-name* "prefs.lsp")
(failsafe-load *prefs-dir-name* "desktop.lsp")
(failsafe-load *prefs-dir-name* "workmap.lsp")

(setf *fake-datasheet* nil)

(when (= *run-number* 1) 
      (send *vista* :desktop-location '(30 30))
      (send *vista* :desktop-size (- (screen-size) '(30 30)))
      (send *vista* :workmap-proportion .6)
      (send *vista* :spreadplot-sizes (- (screen-size) '(30 30))))

(defun seven-desktop-values ()
  (let* ((seven-values
          (combine (send *vista* :desktop-size)
                   (send *vista* :desktop-location)
                   (send *vista* :workmap-proportion)
                   (send *vista* :spreadplot-sizes)))
         )
    (setf *seven-values* seven-values)))
(seven-desktop-values)

(when *verbose* (format t "~%Just read Workmap files~%") )


#+containers
(cond
 (*ni*
  (progn
   (defmeth *desktop-container* :resize ()
     (call-next-method)
     (send *vista* :desktop-size (send self :size)))

   (enable-container *desktop-container*)
   (setf *about-window* nil)
   (setf *fake-datasheet* 
         (send graph-proto :new 2 :show nil 
               :location (list 100 100) :size (list 100 100)))
   (send *fake-datasheet* :add-slot 'showing)
   (disable-container)))
  (t
   (setf *about-window* nil)
   (setf *fake-datasheet* 
         (send graph-proto :new 2 :show nil 
               :location (list 100 100) :size (list 100 100)))
   ))

(when (< (min (- *max-screen-size* *now-screen-size*)) 0) 
      (format t "; screen size adjusted for larger screen~%")
      (setf *screen-size* (- *max-screen-size* *screen-size-adjustment*))
      (setf screen-size *screen-size*)
      (setf *now-screen-size* *max-screen-size*)
      (send *vista* :spreadplot-sizes *max-screen-size*)
      )

(send *vista* :color-values-list 
      (list *workmap-background* *toolbar-background* 
            *data-icon-color*  *model-icon-color* 
            *tool-icon-color* *guide-icon-color* 
            *button-on-color* *button-off-color*))

(when (= *color-mode* 0)(send *vista* :turn-color-off))
(defun about-vista () (about-vista-with-logo))

#|_______________________________
 |
 | create workmap 
 |_______________________________ 
 |#

(WHEN *VERBOSE* (format t "; CREATE WORKMAP"))

#-msdos(send *vista* :create-help-window :show nil :location (list 78 78))

(send *vista* :show-toolbar)
(send *workmap* :toolbar t)
(send *toolbar* :draw-toolbar :show t);nil ng
(send *workmap* :show-toolbar)
(send *workmap* :icon-spacing? (send *workmap* :new-icon-style?))
(send *workmap* :title "WorkMap")
(when *verbose*  (format t "; *screen-size*  ~d~%" *screen-size*))
(when *verbose* (print "CREATED WORKMAP"))

#|_______________________________
 |
 | make desktop listener 
 |_______________________________ 
 |#

(setf *listener* nil)
(when *verbose* (format t "; MAKE DESKTOP LISTENER"))
(enable-container *desktop-container*)
(setf *listener* (send listener-proto :new :show t))

(defmeth *listener* :close ()
  (send self :pop-out nil)
  (desktop-listener))
(disable-container)
(when *verbose* (format t "; focus returned to XLispStat Listener~%"))

(WHEN *VERBOSE* (max-mainwindow))

#|_______________________________
 |
 | install plugins
 |_______________________________ 
 |#


(when *verbose* (format t "; INSTALL PLUGINS"))
(setf *plugins-changed* nil)
(send *workmap* :num-toolbar-buts *nmobs*)
(send *toolbar* :num-icons *nmobs*)
(mapcar #'(lambda (file) (gc) (load file))
           (sort-data (directory (strcat *plugins-dir-name* "*.lsp"))))

(unless (= (send *toolbar* :num-icons) 
           (length (send *vista* :previous-plugins)))
        (setf *plugins-changed* t))

(when (> *num-toolbar-buts-shown-at-startup* (send *workmap* :num-toolbar-buts))
      (setf *num-toolbar-buts-shown-at-startup* (send *workmap* :num-toolbar-buts)))
(when *plugins-changed* 
      (send *toolbox* :set-new-buttons-shown 
            (iseq (length (send *vista* :plugins))))
      (send *vista* :previous-plugins (send *vista* :plugins)))

(send *vista* :analysis-menu-item-titles 
(mapcar #'(lambda (item) (send item :title))
        (send *vista* :remove-dash-menu-items *analyze-menu*)))

(send *toolbar* :change-num-tools-shown *num-toolbar-buts-shown-at-startup* )
(when *verbose* (print "INSTALLED PLUGINS"))
(save-plugin-settings)

#|_______________________________
 |
 | create desktop 
 |_______________________________
 |#

(when *verbose* (print "CREATING DESKTOP"))
(send *fake-datasheet* :title "Empty DataSheet")
(send *fake-datasheet* :clear)
(send *fake-datasheet* :back-color 'white)
(setf *datasheet* *fake-datasheet*)
(send *fake-datasheet* :add-slot 'showing)
#+macintosh(send *listener* :show-window)
(send *vista* :make-watcher :show nil)
(when *verbose* (print "STARTING DESKTOP"))
(when *verbose* (print (list "*ni* " *ni*)))
;if hangs here, because *ni* is nil



(start-desktop :show (not *hide-vista*))



(when *verbose* (print "CREATED DESKTOP"))
(install-command-menu)
(send *workmap* :resize)
(when *needs-desktop-resized*
      (format t "; screen-size reset: *screen-size*  ~d~%" *screen-size*)
      (message-dialog "Adapting to New Screen Size.")
      (refresh-desktop))
(setf screen-size *screen-size*)

#|______________ PHASE 3 _________________|#


(when (load (strcat *default-path* "update\\phase3.lsp") :if-does-not-exist nil)
      (setf *updated* t)
      (when *verbose* (format t "; phase3 update")))

#+macintosh(send *listener* :title "Listener")
#+macintosh(make-cursor 'no-action 3)
#+macintosh(make-cursor 'i-beam 1)
#+X11 (send xlisp::*fake-menu-bar* :location 1 38)
#+X11 (send xlisp::*fake-menu-bar* :size 500 27)
#+X11 (defmeth xlisp::*fake-menu-bar* :close ())
#+X11 (send *workmap* :location 1 120)
#+X11 (send *workmap* :size 500 280)
#+X11 (defmeth XLISP::*FAKE-MENU-BAR* :close () (quit))


(send *workmap* :enabled-trans-menu t)
(send *trans-menu* :enabled nil)
(send *toolbar* :restore-toolbar)
(when *verbose* (print "DID SOME MENU STUFF"))
(setf *open-edit-here-directory* 
      (if *pro-version* *default-path* *user-dir-name*))
(setf *open-data-here-directory* *data-dir-name*)
(setf *open-import-here-directory* *default-path*)
(setf *desktop-datasheet* nil)
#+containers(enable-container *desktop-container*)
(cond 
  (*initial-datasheet*
      (let ((rtdu *realtime-datasheet-update*))
        (setf *realtime-datasheet-update* nil)
        (setf *desktop-datasheet* (new-data "hidden" t))
        (setf *datasheet* *desktop-datasheet*)
        (setf *realtime-datasheet-update* rtdu)))
  (t (setf *desktop-datasheet* *fake-datasheet*)
     ))
#+containers(disable-container)

(when *verbose* (print "DID REAL-TIME-DATASHEET-UPDATE"))
(send *desktop-datasheet* :show-window)
(when *verbose* (print "AFTER DATASHEET SHOW-WINDOW"))
#+containers
(defmeth *desktop-container* :do-key (c m1 m2)
  (send *current-datasheet* :do-key c m1 m2))
;MAKES ICONS LOCATE CORRECTLY WHEN WINDOW CLOSED
(SEND *WORKMAP* :SIZE 475 280)
(when *verbose* (print "BEFORE UNCOMPILABLE FUNCTIONS"))

(when (or *pro-version* *devel-mode*) 
      (set-vista-pro-version)
      (developer-mode)
      (developer-mode))
(send *workmap* :no-move t)
(send *desktop-datasheet* :no-move t)
(send *var-window* :no-move t)
(send *obs-window* :no-move t)
(send *varobs-obj* :no-move t)
(send *workmap* :has-h-scroll nil)
(send *workmap* :has-v-scroll nil)
(send *desktop-datasheet* :has-h-scroll nil)
(send *desktop-datasheet* :has-v-scroll nil)
(send *var-window* :has-v-scroll nil)
(send *obs-window* :has-v-scroll nil)
(apply #'send *desktop-container* :location 
       (select *desktop-start-loc-size* '(0 1)))
(apply #'send *desktop-container* :size 
       (select *desktop-start-loc-size* '(2 3)))
(setf *vista-help* (send menu-item-proto :new "Topics"))
(send *vista* :background-color t)
(send *toolbar* :change-num-tools-shown
      *num-toolbar-buts-shown-at-startup*)
(when *verbose* (format t "~%Updated Number of Toolbar Buttons"))
(create-popup-menus)
(when *verbose* (format t "~%Made popups"))
(send *vista* :frames-per-second *frames-per-second*)

#|
 | if first run and is pro-version (which depends on user-mode, admin-mode 
 | and directory structure) then set devel-mode to t. never change devel mode again
 |#     
             
(set-vista-distributor-mode)
(menus t)
(make-version)
(send *listener* :frame-location 0 (- (fourth *desktop-start-loc-size*) 4))
(send *listener* :size (third *desktop-start-loc-size*) 64)
(send *listener* :no-move t)
(send *varobs-obj* :show-window)


#|______________ PHASE 4 _________________|#


(when (load (strcat *default-path* "update\\phase4.lsp") :if-does-not-exist nil)
      (setf *updated* t)
      (when *verbose* (format t "; phase4 update")))
(when *verbose* (FORMAT T "~5%READY FOR END GAME! :-)~5%"))
(msw-write-profile-string "ViSta" "ViStaOp" "no" *ini-file*)
(msw-write-profile-string "ViSta" "Starter"  nil *ini-file*)
(msw-write-profile-string "ViSta" "Startup"  nil *ini-file*)


#|
 | FINAL OPENING SEQUENCE
 |#

  (when *verbose* (format t "; doing opening sequence~%"))
  (setf logolocsize (combine (send *logo* :location) (send *logo* :size)))
  (startup-defs-vista-xlisp )
  (load-gui)
  (setf *realtime-datasheet-update* t)
  (setf *vista-startup* t)
  (send *desktop-container* :location 
        (first *desktop-start-loc-size*)
        (second *desktop-start-loc-size*))
  (send *desktop-container* :size 
        (third *desktop-start-loc-size*)
        (fourth *desktop-start-loc-size*))
  (when (= *run-number* 1) 
        (send *desktop-container* :make-desktop-container-default-layout))
  (send *vista* :desktop-size (select *seven-values* (list 0 1)))
  (send *vista* :workmap-proportion (select *seven-values* 4))
  (send *vista* :spreadplot-sizes (select *seven-values* (list 5 6)))
  (refresh-desktop) 
  (send *listener* :frame-location 0 (- (fourth *desktop-start-loc-size*) 4))
  (send *listener* :size (third *desktop-start-loc-size*) 54)
  (send *listener* :no-move t)
  (send *vista* :desktop-location (select *seven-values* (list 2 3)))
  (send *vista* :desktop-size (select *seven-values* '(0 1)))
  (apply #'send *desktop-container* :location (select *seven-values* (list 2 3)))
  (vista-copyright *run-number* 3 t nil t)
  (format t "> ")
  (send *desktop-container* :size 
        (select *seven-values* 0)
        (select *seven-values* 1))
  (send *desktop-container* :make-desktop-container-resize)
  (send *desktop-container* :make-desktop-container-size)
  (setf *num-listener-lines* *default-num-listener-lines*)
  (when *maximized-listener?* (maximize-listener))
  (save-gui)
  (msw-write-profile-string "ViSta" "ViStaOp" "yes" *ini-file*)
  (setf *desk-up* nil)
  (setf *xlispstat-only* nil)
  (msw-write-profile-string "ViSta" "XLispOnly" "No" *ini-file*)
  (defmeth *logo* :do-idle ())
  (send *logo* :idle-on nil)


  (defun hide-logo ()
    (setf *hide-logo* t)
    (msw-write-profile-string 
     "ViSta" "HideLogo" "Yes" (strcat *default-path* "wxls32.ini")))

  (defun show-logo ()
    (setf *hide-logo* nil)
    (msw-write-profile-string 
     "ViSta" "HideLogo" "No" (strcat *default-path* "wxls32.ini")))

  (defun show-vista ()
"Args: none
Shows the DeskTop. This function includes two different processes for opening the desktop, one prior to and the other after it has been opened for the first time. Prior to *desk-up* time the initial-help and help-panel are also opened, if appropriate. After *desk-up* only the desktop is opened." 
    (cond 
      ((not (boundp '*desk-up*))
       (post-it "DeskTop Not Constructed"))
      ((not *desk-up*)
       (msw-write-profile-string "ViSta" "ViStaOp" "yes" *ini-file*)
       (initialize-msdos-menus)
      ; (menubar "mac" :style "mac")   ;for windows only
      ; (setf *mac-menubar* t)
       (send *desktop-container* :make-desktop-container-resize)
       (when (< (second (send *vista* :desktop-size)) 1)
             (load-gui);if bad desktop values, try gui files
             (when (< (second (send *vista* :desktop-size)) 1)
                   (restore-prefs-files) ;if didn't work, restore prefs from prefs-bak
                   (load-gui :use-backup t)
                   ))
       (cond
         ((> (second (send *vista* :desktop-size)) 0);if still bad, try gui backup files
          (apply #'send *desktop-container* :location (send *vista* :desktop-location))
          (apply #'send *desktop-container* :size (send *vista* :desktop-size)))
         (t
          (send *desktop-container* :frame-location 10 10)
          (apply #'send *desktop-container* :frame-size *3/4-screen-size*)))
      ; (send *desktop-container* :do-idle)
       (let ((wmp (send *vista* :workmap-proportion)))
         (remake-desktop-menu-items *desktop-layout-state* 
                                    (send *vista* :workmap-proportion)
                                    *num-listener-lines*)
         (send *vista* :workmap-proportion wmp))
       ;DESKTOP MAXIMIZE-LISTENER CORRECT HERE (STILL HIDDEN)
       (refresh-desktop)
       (setf *desk-up* t)
       (setf *hide-vista* nil)
       (setf *vista-startup* nil)
       (stop-all-plots)
       (if (= *desktop-layout-state* 2)
           (send *desktop-container* :make-desktop-container-resize-for-maximized-listener)
           (send *desktop-container* :make-desktop-container-resize))
       (send *desktop-container* :front-window);PROPERLY CONFIGURED WINDOW APPEARS
       (if (< *run-number* 2) 
          (initial-presentations *run-number*)
           (unless (equal (string-downcase *starter*) "excel")
                   (when (or (send *vista* :show-welcome) (send *vista* :show-first-help))
                         (show-help-panel))))
       )
      (t
       (send *listener* :pop-out nil)
       (send *desktop-container* :front-window)
       (save-desktop-settings)
       (setf *desk-up* t)
       (setf *hide-vista* nil))))

  (defun process-dde-data ()
    "processes data coming to ViSta by DDE from Excel or Access (or elsewhere)"
    (when (and *desktop-container* *dde-data*)
          (let ((start (get-internal-real-time))
                (elapsed))
            (enable-container *desktop-container*)
            (eval *dde-data*)   
            (disable-container)
            (msw-write-profile-string "ViSta" "ViStaOp" "yes" *ini-file*)
            (format t "; DataStep created data object ~a~%" (send *current-data* :full-name))
            (setf elapsed (/ (- (get-internal-real-time) start)
                             INTERNAL-TIME-UNITS-PER-SECOND))
            (format t "; DDE Data processing time: ~d seconds.~%" (fuzz elapsed))
            (setf *dde-data* nil)
          ; (send *workmap* :idle-on nil)
            t)))


  (cond 
    (*devel-mode*
     (setf *current-data-dir-name* *data-path*)
     (setf *examples-data-dir-name* *data-path*)
     )
    (t
     ;these definitions override developer-specific versions found elsewhere
     (defun refresh-vista () 
       (restart-vista))
   
     (defun restart-vista (&optional dir)
       (save-all-prefs)
       (if dir
           (system (strcat dir "vista.exe"))
           (system (strcat *default-path* "vista.exe")))
       (exit))

     (setf *current-data-dir-name* *user-path*)
     (setf *examples-data-dir-name* *user-path*)
     ))
  
  (unless *hide-logo*
          (send *logo* :idle-on nil)
          (if *show-flying-logo* 
              (send *logo* :disolve 
                    :direction (1- (mod *run-number* 3))) 
              (send *logo* :remove))
          (setf *hide-logo* nil))

  (defmeth *workmap* :do-idle ()
    (when (process-dde-data) ;so does (eval *dde-data*)
          (send *workmap* :idle-on nil))
    (when (and (not *hide-vista*) (not *vista-has-been-shown*))
          (setf *vista-has-been-shown* t)
          (stop-all-plots)
          (show-vista)
          ))

 ;
 ; (defmeth *workmap* :do-idle ()
 ;   (process-dde-data) ;so does (eval *dde-data*)
 ;   (when (and (not *hide-vista*) (not *vista-has-been-shown*))
 ;         (setf *vista-has-been-shown* t)
 ;         (stop-all-plots)
 ;         (show-vista)
 ;         (send self :idle-on t)
 ;         ))
  
  (load "vistinit" :if-does-not-exist nil)
  
  (setf *vista-has-been-shown* nil)
  (setf *vista-exists* t)
  (send *workmap* :idle-on t)
  
  );end of create-vista function


